<?php
/**
 * Database Connection
 */

function getDatabase() {
    static $pdo = null;
    
    if ($pdo === null) {
        $config = include __DIR__ . '/../config/database.php';
        
        try {
            $pdo = new PDO($config['dsn'], $config['username'], $config['password'], $config['options']);
        } catch (PDOException $e) {
            error_log('Database connection failed: ' . $e->getMessage());
            die('Database connection failed. Please check your configuration.');
        }
    }
    
    return $pdo;
}
?>