<?php
/**
 * Working Login Page
 * Handles authentication properly
 */

session_start();

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    $redirectUrl = ($_SESSION['user_role'] === 'admin') ? 'admin/' : 'customer/dashboard.php';
    header("Location: {$redirectUrl}");
    exit;
}

$error = '';
$success = '';

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $rememberMe = isset($_POST['remember_me']);
    
    if (empty($email) || empty($password)) {
        $error = 'Please enter both email and password.';
    } else {
        try {
            // Check if system is installed
            if (!file_exists('config/database.php')) {
                $error = 'System not properly installed. Please run the installer.';
            } else {
                $config = include 'config/database.php';
                $pdo = new PDO($config['dsn'], $config['username'], $config['password'], $config['options']);
                
                // Find user by email
                $stmt = $pdo->prepare("SELECT * FROM {$config['prefix']}users WHERE email = ? AND status = 'active'");
                $stmt->execute([$email]);
                $user = $stmt->fetch();
                
                if ($user && password_verify($password, $user['password'])) {
                    // Login successful
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['user_role'] = $user['role'];
                    $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
                    $_SESSION['user_email'] = $user['email'];
                    
                    // Set remember me cookie if requested
                    if ($rememberMe) {
                        $token = bin2hex(random_bytes(32));
                        setcookie('remember_token', $token, time() + (30 * 24 * 60 * 60), '/'); // 30 days
                        
                        // Store token in database (you might want to create a remember_tokens table)
                        // For now, we'll skip this and just set the cookie
                    }
                    
                    // Log the login
                    error_log("User login: {$user['email']} ({$user['role']})");
                    
                    // Redirect based on role
                    $redirectUrl = ($user['role'] === 'admin') ? 'admin/' : 'customer/dashboard.php';
                    
                    // If there's a return URL, use it
                    if (isset($_GET['return']) && !empty($_GET['return'])) {
                        $returnUrl = urldecode($_GET['return']);
                        // Basic security check for return URL
                        if (strpos($returnUrl, 'http') !== 0 && strpos($returnUrl, '//') !== 0) {
                            $redirectUrl = $returnUrl;
                        }
                    }
                    
                    header("Location: {$redirectUrl}");
                    exit;
                    
                } else {
                    $error = 'Invalid email or password.';
                    
                    // Optional: Log failed login attempts
                    error_log("Failed login attempt for: {$email}");
                }
            }
        } catch (Exception $e) {
            $error = 'Login system error. Please try again.';
            error_log("Login error: " . $e->getMessage());
        }
    }
}

// Get site name for display
$siteName = 'Billing System';
try {
    if (file_exists('config/database.php')) {
        $config = include 'config/database.php';
        $pdo = new PDO($config['dsn'], $config['username'], $config['password'], $config['options']);
        $stmt = $pdo->prepare("SELECT value FROM {$config['prefix']}settings WHERE name = 'site_name'");
        $stmt->execute();
        $result = $stmt->fetch();
        if ($result) {
            $siteName = $result['value'];
        }
    }
} catch (Exception $e) {
    // Continue with default name
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= htmlspecialchars($siteName) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        
        .login-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            overflow: hidden;
            max-width: 400px;
            width: 100%;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
        }
        
        .login-header h2 {
            margin: 0;
            font-weight: 600;
        }
        
        .login-header p {
            margin: 10px 0 0;
            opacity: 0.9;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 15px;
            font-size: 16px;
            width: 100%;
            transition: transform 0.2s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
        }
        
        .alert {
            border-radius: 10px;
            border: none;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .form-check {
            margin: 20px 0;
        }
        
        .links {
            text-align: center;
            margin-top: 30px;
        }
        
        .links a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }
        
        .links a:hover {
            text-decoration: underline;
        }
        
        .divider {
            margin: 20px 0;
            text-align: center;
            position: relative;
        }
        
        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background: #dee2e6;
        }
        
        .divider span {
            background: white;
            padding: 0 15px;
            color: #6c757d;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="login-container">
                    <div class="login-header">
                        <i class="fas fa-credit-card fa-2x mb-3"></i>
                        <h2>Welcome Back</h2>
                        <p>Sign in to your account</p>
                    </div>
                    
                    <div class="login-body">
                        <?php if ($error): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?= htmlspecialchars($error) ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                <?= htmlspecialchars($success) ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="post">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="email" name="email" placeholder="name@example.com" required value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                                <label for="email"><i class="fas fa-envelope me-2"></i>Email Address</label>
                            </div>
                            
                            <div class="form-floating">
                                <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                                <label for="password"><i class="fas fa-lock me-2"></i>Password</label>
                            </div>
                            
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember_me" name="remember_me">
                                <label class="form-check-label" for="remember_me">
                                    Remember me for 30 days
                                </label>
                            </div>
                            
                            <button type="submit" class="btn btn-login">
                                <i class="fas fa-sign-in-alt me-2"></i>Sign In
                            </button>
                        </form>
                        
                        <div class="divider">
                            <span>or</span>
                        </div>
                        
                        <div class="links">
                            <a href="register.php">
                                <i class="fas fa-user-plus me-2"></i>Create New Account
                            </a>
                            <br><br>
                            <a href="forgot-password.php">
                                <i class="fas fa-key me-2"></i>Forgot Password?
                            </a>
                            <br><br>
                            <a href="index.php">
                                <i class="fas fa-home me-2"></i>Back to Homepage
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>px;
            transition: border-color 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 15px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 16