<?php
/**
 * Logout Script
 * Properly handles user logout and session cleanup
 */

session_start();

// Log the logout action
if (isset($_SESSION['user_email'])) {
    error_log("User logout: " . $_SESSION['user_email']);
}

// Clear all session variables
$_SESSION = array();

// Delete the session cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Clear remember me cookie if it exists
if (isset($_COOKIE['remember_token'])) {
    setcookie('remember_token', '', time() - 3600, '/');
}

// Destroy the session
session_destroy();

// Redirect to homepage with success message
header('Location: index.php?logout=success');
exit;
?>