<?php
/**
 * Simple PHP Test File
 * Upload this as test.php to check if PHP is working
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🧪 PHP Test Page</h1>";
echo "<style>body{font-family:Arial;margin:20px;background:#f5f5f5;}</style>";

echo "<div style='background:white;padding:20px;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);'>";

// Basic PHP info
echo "<h2>✅ PHP is working!</h2>";
echo "<p><strong>PHP Version:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>Server Time:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<p><strong>Current Directory:</strong> " . getcwd() . "</p>";

// Test database connection
echo "<h2>🗄️ Database Test</h2>";

// Prompt for database details
if (!isset($_POST['test_db'])) {
    echo "<form method='post'>";
    echo "<h3>Enter Database Details:</h3>";
    echo "<p><label>Host: <input type='text' name='db_host' value='localhost' style='padding:5px;width:200px;'></label></p>";
    echo "<p><label>Database: <input type='text' name='db_name' placeholder='yourusername_dbname' style='padding:5px;width:200px;'></label></p>";
    echo "<p><label>Username: <input type='text' name='db_user' placeholder='yourusername_user' style='padding:5px;width:200px;'></label></p>";
    echo "<p><label>Password: <input type='password' name='db_pass' style='padding:5px;width:200px;'></label></p>";
    echo "<p><button type='submit' name='test_db' style='padding:10px 20px;background:#007bff;color:white;border:none;border-radius:4px;'>Test Database</button></p>";
    echo "</form>";
} else {
    $host = $_POST['db_host'];
    $name = $_POST['db_name'];
    $user = $_POST['db_user'];
    $pass = $_POST['db_pass'];
    
    try {
        $dsn = "mysql:host={$host};dbname={$name};charset=utf8mb4";
        $pdo = new PDO($dsn, $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]);
        
        echo "<p style='color:green;'>✅ Database connection successful!</p>";
        echo "<p><strong>Database:</strong> {$name}</p>";
        echo "<p><strong>Connection:</strong> Active</p>";
        
        // Test query
        $stmt = $pdo->query("SELECT VERSION() as version");
        $version = $stmt->fetch();
        echo "<p><strong>MySQL Version:</strong> " . $version['version'] . "</p>";
        
    } catch (Exception $e) {
        echo "<p style='color:red;'>❌ Database connection failed:</p>";
        echo "<p style='background:#f8d7da;padding:10px;border-radius:4px;'>" . $e->getMessage() . "</p>";
        
        echo "<h3>Common Database Issues:</h3>";
        echo "<ul>";
        echo "<li><strong>Wrong database name:</strong> Use full name like 'username_dbname'</li>";
        echo "<li><strong>User not added to database:</strong> In cPanel, add user to database with ALL PRIVILEGES</li>";
        echo "<li><strong>Wrong host:</strong> Usually 'localhost' for cPanel</li>";
        echo "</ul>";
    }
}

// Check file permissions
echo "<h2>📁 File Permissions Test</h2>";
$testDir = 'test_config';
if (!is_dir($testDir)) {
    if (mkdir($testDir, 0755)) {
        echo "<p style='color:green;'>✅ Can create directories</p>";
        rmdir($testDir);
    } else {
        echo "<p style='color:red;'>❌ Cannot create directories</p>";
    }
} else {
    echo "<p style='color:orange;'>⚠️ Test directory already exists</p>";
}

$testFile = 'test_write.txt';
if (file_put_contents($testFile, 'test')) {
    echo "<p style='color:green;'>✅ Can write files</p>";
    unlink($testFile);
} else {
    echo "<p style='color:red;'>❌ Cannot write files</p>";
}

// PHP Extensions check
echo "<h2>🔧 PHP Extensions</h2>";
$required = ['pdo', 'pdo_mysql', 'curl', 'openssl', 'json'];
foreach ($required as $ext) {
    $loaded = extension_loaded($ext);
    echo "<p style='color:" . ($loaded ? 'green' : 'red') . ";'>";
    echo ($loaded ? '✅' : '❌') . " {$ext}: " . ($loaded ? 'Loaded' : 'Missing');
    echo "</p>";
}

echo "</div>";

// Next steps
echo "<div style='background:white;padding:20px;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);margin-top:20px;'>";
echo "<h2>🚀 Next Steps</h2>";
echo "<ol>";
echo "<li>If this page works, PHP is fine</li>";
echo "<li>If database test passes, create the billing system tables</li>";
echo "<li>Check your main files for syntax errors</li>";
echo "<li>Look at cPanel Error Logs for specific errors</li>";
echo "</ol>";

echo "<h3>Quick Database Setup:</h3>";
echo "<p>In cPanel:</p>";
echo "<ol>";
echo "<li>Go to <strong>MySQL Databases</strong></li>";
echo "<li>Create database: <code>yourusername_billing</code></li>";
echo "<li>Create user: <code>yourusername_billuser</code></li>";
echo "<li>Add user to database with <strong>ALL PRIVILEGES</strong></li>";
echo "</ol>";
echo "</div>";
?>